#!/usr/bin/python
# vim: tabstop=4 expandtab shiftwidth=4 softtabstop=4

from aja.controlroom.base import *
import json


class Prefs(Base):

    def __init__(self, connection):
        Base.__init__(self, connection)

    # sets
    def setSize(self, width, height):
        cmd = "/prefs/set_size/%sx%s" % (width, height)
        self.issue_cmd(cmd)

    def setPosition(self, x, y):
        cmd = "/prefs/set_position/%s,%s" % (x, y)
        self.issue_cmd(cmd)

    def setVisible(self, value):
        cmd = "/prefs/set_visible/%s" % (value)
        self.issue_cmd(cmd)

    # gets
    def size(self):
        cmd = "/prefs/size"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]  # {w: int, h: int}

    def position(self):
        cmd = "/prefs/position"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]  # {x: int, y: int}

    def visible(self):
        cmd = "/prefs/visible"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]
