#!/usr/bin/python
# vim: tabstop=4 expandtab shiftwidth=4 softtabstop=4

from aja.controlroom.base import * 
import json


class Bin(Base):

    def __init__(self, connection):
        Base.__init__(self, connection)

    def addFile(self, filePath):
        listOfFiles = [filePath]
        self.addFiles(listOfFiles)

    def addFiles(self, listOfFiles):
        cmd = "/bin/add_files/"
        for path in listOfFiles:
            cmd = cmd + self.encode_path(path) + "<=>"

        self.issue_cmd(cmd)

    def files(self):
        cmd = "/bin/files"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]

    def setVisible(self, value):
        cmd = "/bin/set_visible/%s" % (value)
        self.issue_cmd(cmd)

    def visible(self):
        cmd = "/bin/visible"
        jsonVals = json.loads(self.issue_cmd(cmd))
        return jsonVals["value"]
