#!/usr/bin/python
# vim: tabstop=8 expandtab shiftwidth=4 softtabstop=4

import sys
import os
sys.path.append("../")

from aja.controlroom.client import Client
import time


def simplePlayback(client,file):
	#setup the window to viewer only
	client.app.setPosition(300,100)
	client.app.setSize(1000,700)
	client.bin.setVisible(True)
	client.viewer.setMode("playback")
	
	#make sure file is in bin
	filesInBin = client.bin.files()
	if any(file in filePath for filePath in filesInBin) == False:
		client.bin.addFile(file)
		#wait a bit
		time.sleep(1.0)

	client.viewer.playFile(file)
        

def main():
	"""
	Used for testing
	"""
	server = 'localhost'
	port   = '8080'
	
# Example - load and playback file. Replace filename with file on your system
	client = Client(server,port)
	simplePlayback(client,"/Users/steven/Movies/Testmovie.mov")

# Example - Add files to bin. Replace filenames with files on your system
#	client.bin.addFiles (["/Users/steven/Movies/Movie1.mov", "/Users/steven/Movies/Movie2.mov"])
		
# Example - Print list of files in bin
	#print client.bin.files()
		
#Example - Load files from directory. Replace moviePath with valid path to movies on your system
#	moviePath = "/users/demo/Desktop/movies/"
#	movieFiles = os.listdir(moviePath)

#	for file in movieFiles:
#		print (moviePath+file)
#		client.bin.addFile(moviePath+file)
	


if __name__ == '__main__':
	status = main()
	sys.exit(status)

